/*
 * Copyright (c) 2013-2023, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef ARMV8_PMUV3_EVENTS_H
#define ARMV8_PMUV3_EVENTS_H

#include <inttypes.h>

#define PMU_SELECTED_END           0xC0BF
#define CYCLE_COUNTER_EVENT        (PMU_SELECTED_END-1)

/* Describe each PMU event */
struct pmu_event {
	const int number;
	const char *name;
};

/* Describe each selected PMU event for profiling */
struct pmu_event_selected {
	struct pmu_event event;
	int cnt_idx;
	// For Armv8.5 and after, all pmu event counters are 64-bit
	uint64_t preval;
	uint64_t postval;
};

#endif /* ARMV8_PMUV3_EVENTS_H */